package gov.va.med.mhv.getcare.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang3.StringUtils;
import javax.faces.component.UIInput;

/*
 * valid patterns are
 * 99999			5 digits
 * 999999999		9 digits
 * 99999-9999		5+4 digits
 *
 * note: can have leading and trailing spaces
 * in future, if you didn't want that change it to "^{pattern}$" instead of " *{pattern} *"
 */
@FacesValidator(value="ZipCodeValidator")
public class ZipCodeValidator implements Validator {

	private static final String PATTERN1 = " *\\d{5} *"; // 5 digits
	private static final String PATTERN2  = " *\\d{9} *"; // 9 digits
	private static final String PATTERN3 = " *\\d{5}-\\d{4} *"; // 99999-9999
	private static final String UNITED_STATES="United States";
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.validator.Validator#validate(javax.faces.context.
	 * FacesContext, javax.faces.component.UIComponent, java.lang.Object)
	 */
	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		String zip = (String) value;
		boolean skipValidation = false;

		if (zip == null || zip.isEmpty()) {
			return; // Let required="true" or @NotNull handle it.
		}
		UIInput selectedCountryComponent = (UIInput)component.getAttributes().get("selectedCountry");
		if(selectedCountryComponent!=null){
			try{
				String country = (String)selectedCountryComponent.getSubmittedValue();
				if(StringUtils.isNotEmpty(country)){
					if(!UNITED_STATES.equalsIgnoreCase(country)){	
						skipValidation = true;
					}
				}
				selectedCountryComponent.setValid(true);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		if(!skipValidation){
			if (!zip.matches(PATTERN1) && !zip.matches(PATTERN2) && !zip.matches(PATTERN3) ) {
				String summary = String.format("'%s' is not a valid zip code.", zip);
				String detail = "Enter either a 5 or 9 digit zip code.";
				throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
			}
		}
	}

}
